/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.config.sync;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class SyncConfig {
    public static ForgeConfigSpec.ConfigValue<List<String>> INTERACT_KEY_WHITELIST_BLOCKS;
    public static ForgeConfigSpec.ConfigValue<List<String>> INTERACT_KEY_WHITELIST_ENTITIES;
    public static ForgeConfigSpec.ConfigValue<List<String>> INTERACT_KEY_BLACKLIST_BLOCKS;
    public static ForgeConfigSpec.ConfigValue<List<String>> INTERACT_KEY_BLACKLIST_ENTITIES;
    public static ForgeConfigSpec.DoubleValue DAMAGE_BASE_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue ARMOR_IGNORE_BASE_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue HEAD_SHOT_BASE_MULTIPLIER;
    public static ForgeConfigSpec.ConfigValue<List<String>> HEAD_SHOT_AABB;
    public static ForgeConfigSpec.IntValue AMMO_BOX_STACK_SIZE;
    public static ForgeConfigSpec.ConfigValue<List<List<String>>> CLIENT_GUN_PACK_DOWNLOAD_URLS;

    public static void init(ForgeConfigSpec.Builder builder) {
        SyncConfig.interactKey(builder);
        SyncConfig.baseMultiplier(builder);
        SyncConfig.misc(builder);
    }

    public static void interactKey(ForgeConfigSpec.Builder builder) {
        builder.push("interact_key");
        builder.comment("These whitelist blocks can be interacted with when the interact key is pressed");
        INTERACT_KEY_WHITELIST_BLOCKS = builder.define("InteractKeyWhitelistBlocks", (Object)Lists.newArrayList());
        builder.comment("These whitelist entities can be interacted with when the interact key is pressed");
        INTERACT_KEY_WHITELIST_ENTITIES = builder.define("InteractKeyWhitelistEntities", (Object)Lists.newArrayList());
        builder.comment("These blacklist blocks can be interacted with when the interact key is pressed");
        INTERACT_KEY_BLACKLIST_BLOCKS = builder.define("InteractKeyBlacklistBlocks", (Object)Lists.newArrayList());
        builder.comment("These blacklist entities can be interacted with when the interact key is pressed");
        INTERACT_KEY_BLACKLIST_ENTITIES = builder.define("InteractKeyBlacklistEntities", (Object)Lists.newArrayList());
        builder.pop();
    }

    private static void baseMultiplier(ForgeConfigSpec.Builder builder) {
        builder.push("base_multiplier");
        builder.comment("All base damage number is multiplied by this factor");
        DAMAGE_BASE_MULTIPLIER = builder.defineInRange("DamageBaseMultiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.comment("All armor ignore damage number is multiplied by this factor");
        ARMOR_IGNORE_BASE_MULTIPLIER = builder.defineInRange("ArmorIgnoreBaseMultiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.comment("All head shot damage number is multiplied by this factor");
        HEAD_SHOT_BASE_MULTIPLIER = builder.defineInRange("HeadShotBaseMultiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
    }

    private static void misc(ForgeConfigSpec.Builder builder) {
        builder.push("misc");
        builder.comment("The entity's head hitbox during the headshot");
        builder.comment("Format: touhou_little_maid:maid [-0.5, 1.0, -0.5, 0.5, 1.5, 0.5]");
        HEAD_SHOT_AABB = builder.define("HeadShotAABB", (Object)Lists.newArrayList());
        builder.comment("The maximum stack size of ammo that the ammo box can hold");
        AMMO_BOX_STACK_SIZE = builder.defineInRange("AmmoBoxStackSize", 3, 1, Integer.MAX_VALUE);
        builder.comment("The gun pack that the client player needs to download, needs to fill in the URL and the SHA1 value of the file");
        CLIENT_GUN_PACK_DOWNLOAD_URLS = builder.define("ClientGunPackDownloadUrls", (Object)Lists.newArrayList());
        builder.pop();
    }
}

